﻿#!/usr/bin/perl
use XML::Simple;
use Data::Dumper;
use Perl6::Slurp;
use DBI;
use Date::Manip;
use Date::Simple;
use DateTime;
use CGI;
use CGI::Lite;
use KCatch;
use SVG;
use MIME::Base64;
#use utf8;

Date_Init("TZ=JST","ConvTZ=JST");

my $dbh = DBI->connect("dbi:SQLite:dbname=ch.db", undef, undef, {
    AutoCommit => 1,
    RaiseError => 1,
});

my $HTML;

#print "Content-Type: text/html\n\n";

$HTML .= <<EOM;
Content-Type: text/html


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<title>Rec10</title>
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link rev="MADE" href="Rea10"> 
%REFRESH%
</head>
<body>
EOM


$q = new CGI;
$mode = $q->param( 'mode' );

$display = $q->param( 'ch' );
$start   = $q->param( 'start' );
$stop    = $q->param( 'stop' );
$key     = $q->param( 'key' );
@id      = $q->param( 'id' );

if ( $mode eq 'schedule' ) {
	my $ary_ref = $dbh->selectall_arrayref("SELECT id, type, chtxt, title, btime, etime, opt FROM rectime");
	$HTML .= qq {<div style="font-size: 8pt; float:left;">\n};
	$HTML .= qq {<a href="rectool.pl?mode=graph">グラフィカルな予約状況はこちら</a>\n<br>\n};
	$HTML .= qq {<form method="get" action="rectool.pl">\n<input type="hidden" name="mode" value="delete">\n};
	$HTML .= qq {<table summary="rectimetable">\n<tr>\n<th><br></th>\n<th>ID</th>\n<th>タイプ</th>\n<th>チャンネル</th>\n};
	$HTML .= qq {<th>タイトル</th>\n<th>開始時刻</th>\n<th>終了時刻</th><th>録画時間</th><th>オプション</th>\n</tr>\n};
	foreach my $line ( @{ $ary_ref } ) {
		if ( $line->[1] eq 'res' ) {
			$line->[1] = '一回限定';
		}
		if ( $line->[1] eq 'rec' ) {
			$line->[1] = '最終段階';
		}
		if ( $line->[1] eq 'key' ) {
			$line->[1] = '検索録画';
		}
		if ( $line->[1] eq 'keyevery' ) {
			$line->[1] = '隔日検索';
		}
		if ( $line->[1] eq 'tsfin' ) {
			$line->[1] = '解読終了';
		}
		if ( $line->[1] eq 'tsdecoding' ) {
			$line->[1] = '録画途中';
		}
		if ( $line->[1] eq 'ts2avi' ) {
			$line->[1] = '変換予約';
		}
		if ( $line->[1] eq 'local' ) {
			$line->[1] = '変換於鯖';
		}
		if ( $line->[1] eq 'fin_local' ) {
			$line->[1] = '縁故完了';
		}
		if ( $line->[1] eq 'grid' ) {
			$line->[1] = '縁故於網';
		}
		if ( $line->[1] eq 'end' ) {
			$line->[1] = '録画終了';
		}
		$diff = ( UnixDate($line->[5], '%s') - UnixDate($line->[4], '%s') ) / 60;
		$begin = UnixDate( $line->[4], '%m/%d %H:%M' );
		$end   = UnixDate( $line->[5], '%m/%d %H:%M' );
		$end   = UnixDate( $line->[5], '%H:%M' )if ( UnixDate( $line->[4], '%m/%d' ) eq UnixDate( $line->[5], '%m/%d' ) );
		my $hour = int( $diff / 60 );
		my $min  = $diff - $hour * 60;
		$diff = '';
		$diff .= $hour . '時間' if ( $hour );
		$diff .= $min  . '分'   if ( $min );
		$HTML .= qq {<tr align="center">\n<td><input type="checkbox" name="id" value="$line->[0]"></td>\n};
		$HTML .= qq {<td>$line->[0]</td>\n<td>$line->[1]</td>\n<td>$line->[2]</td>\n<td>$line->[3]</td>\n};
		$HTML .= qq {<td>$begin</td>\n<td>$end</td>\n<td>$diff</td>\n<td>$line->[6]</td>\n</tr>\n};
	}
	$HTML .= qq {</table>\n<input type="submit" value="削除">\n</form>\n};
	goto end;
}

if ( $mode eq 'graph' ) {

	$graph = $q->param( 'graph' );

	if ( $graph )
	{
		print "Content-Type: image/svg+xml\n\n";

		$graph2 = Date::Simple->new( split /-/, $graph )->next->format('%Y-%m-%d');
		$day = Date::Simple->new( split /-/, $graph )->day;
		$svg = new SVG( width => 820, height => 120 );
		$width = 750;
		$svg->rectangle( 'x' => 40, 'y' => 20, width => $width + 20, height => 90, rx => 15, ry => 15,
			style => { stroke => 'blue', fill => 'white' } );
		$svg->text( 'x' => 10, 'y' => 40 )
			->cdata( 'T1' );
		$svg->text( 'x' => 10, 'y' => 60 )
			->cdata( 'T2' );
		$svg->text( 'x' => 10, 'y' => 80 )
			->cdata( 'S1' );
		$svg->text( 'x' => 10, 'y' => 100 )
			->cdata( 'S2' );
		for ( 0..25 ) {
			$svg->text( 'x' => 60 + $_ * 30, 'y' => 15 )
				->cdata( sprintf( '%02d', $_ ) ) if ( $_ < 25 );
			$svg->line( x1 => 50 + $_ * 30, x2 => 50 + $_ * 30, y1 => 30, y2 => 100,
				style => { stroke => 'gray' } );
		}
		$svg->rectangle( 'x' => 50, 'y' => 30, width => $width, height => 10 );
		$svg->rectangle( 'x' => 50, 'y' => 50, width => $width, height => 10 );
		$svg->rectangle( 'x' => 50, 'y' => 70, width => $width, height => 10 );
		$svg->rectangle( 'x' => 50, 'y' => 90, width => $width, height => 10 );
		foreach my $bctype ( 'te%', '_s' ) {
			my $ary_ref = $dbh->selectall_arrayref(
				"SELECT id, type, rectime.chtxt, title, btime, etime, opt FROM rectime 
				INNER JOIN chdata ON rectime.chtxt = chdata.chtxt 
				WHERE chdata.bctype LIKE '$bctype' 
				AND '$graph 00:00' <= btime AND etime <= '$graph2 01:00'"
			);
			foreach my $line ( @{ $ary_ref } ) {
				@start = $line->[4] =~ /(.{4})-(.{2})-(.{2}) (.{2}):(.{2})/;
				@stop  = $line->[5] =~ /(.{4})-(.{2})-(.{2}) (.{2}):(.{2})/;
				$start = ( ( $day == $start[2] ? 0 : 24 * 60 ) + $start[3] * 60 + $start[4] ) * 0.5;
				$stop  = ( ( $day == $stop [2] ? 0 : 24 * 60 ) + $stop [3] * 60 + $stop [4] ) * 0.5;
				$begin = $line->[4];
				$end   = $line->[5];

				my $ary = $dbh->selectall_arrayref( 
					"SELECT id, type, rectime.chtxt, title, btime, etime, opt FROM rectime 
					INNER JOIN chdata ON rectime.chtxt = chdata.chtxt 
					WHERE chdata.bctype LIKE '$bctype' AND 
					( 
						( btime < '$begin' AND '$begin' < etime ) 
							OR 
						( btime < '$end'   AND '$end'   < etime ) 
					)" 
				);
				my @ary = @{$ary};
				for ( 0..1) {
					$f = 1;
					$i = $_;
					for ( 0..4 ) {
						$f = 0 if ( $line->[$_] ne $ary[$i]->[$_] );
					}
					if ( $f ) {
						$slot = $i;
					}
				}
				if ( $line->[6] =~ /a/ ) {
					$color = 'rgb(255,0,0)';
				}
				else {
					$color = 'rgb(0,255,0)';
				}
				$svg->rectangle( 'x' => 50 + $start, 'y' => 30 + ( $bctype eq 'te%' ? 0 : 1 ) * 40 + $slot * 20, width => $stop - $start, height => 10,
					style => { fill => $color } );
			}
		}
		print $svg->xmlify;
		exit;
	}
	else
	{
		$HTML .= qq{<div style="float:left;">\n};
#		$base64 = encode_base64( $svg->xmlify );
#		$HTML .= qq{<object data="data:image/svg+xml;base64,$base64">\n</object>\n};
		$HTML .= qq{予約状況一覧です。赤はアニメ、緑はそれ以外を示しています。<br>\n};
		$HTML .= qq{SVGが利用可能なブラウザでご覧ください。<br>\n};

		$ary_ref = $dbh->selectcol_arrayref("SELECT DISTINCT SUBSTR(start, 0, 9) FROM tv");
		$date_sel = $q->param( 'date' );
		foreach my $date ( @{ $ary_ref } ) {
			my @date = $date =~ /(.{4})(.{2})(.{2})/;
			$HTML .= qq{$date[0]-$date[1]-$date[2]の予約状況<br>\n};
			$HTML .= qq{<object data="rectool.pl?mode=graph&amp;graph=$date[0]-$date[1]-$date[2]" width=820 height=120>\n};
			$HTML .= qq{$date[0]-$date[1]-$date[2]\n</object>\n<br>\n};
			$date_prt = "$date[1]/$date[2]";
		}

		goto end;
	}
}

if ( $mode eq 'delete' ) {
	if ( @id ) {
		foreach my $id ( @id ) {
			$dbh->do( "DELETE FROM rectime WHERE id = '$id'" );
		}
		$HTML .= "削除しました。<br>\n5秒後にスケジュール管理画面に移動します。<br>\n";
		$HTML =~ s|%REFRESH%|<meta http-equiv="refresh" content="5; url=rectool.pl?mode=schedule">|;
		goto end;
	}
}

if ( $mode eq 'confirm' ) {
	# && $display && $start && $stop

	$HTML .= qq {<div style="float:left;">\n};
	&parse_program();
	if ( &check_error() )
	{
		# エラー
	}
	else {
		$desc = $dbh->selectrow_array("SELECT desc FROM tv WHERE channel = '$channel' AND start = '$start' AND stop = '$stop' ");
		$HTML .= "録画予約の詳細設定を行ってください。<br>\n";
		$HTML .= "番組の詳細は以下のとおりです。<br>\n";
		$HTML .= "番組名：$title<br>\n$desc<br>\n";
		$HTML .= qq {<form method="get" action="rectool.pl">\n};
		$HTML .= qq {<input type="hidden" name="mode"  value="reserve">\n};
		$HTML .= qq {<input type="hidden" name="ch"    value="$display">\n};
		$HTML .= qq {<input type="hidden" name="start" value="$start">\n};
		$HTML .= qq {<input type="hidden" name="stop"  value="$stop">\n};
		$HTML .= qq {<select name="opt">\n};
		$HTML .= qq {<option value="S">SD画質(720x480)</option>\n};
		$HTML .= qq {<option value="H">HD画質(1280x720)</option>\n};
		$HTML .= qq {<option value="Q">WQVGA画質(400x240)</option>\n};
		$HTML .= qq {<option value="F">FULLHD画質(1920x1080)</option>\n};
		$HTML .= qq {</select>\n};
		$HTML .= qq {<input type="checkbox" name="opt" value="a">アニメ\n};
		if ( $title =~ /\Q[二]\E/ ) {
			$HTML .= qq {<input type="checkbox" name="opt" value="d" checked>二ヶ国語放送\n};
		}
		else {
			$HTML .= qq {<input type="checkbox" name="opt" value="d">二ヶ国語放送\n};
		}
		$HTML .= qq {<input type="checkbox" name="opt" value="2">2passモード\n};
		$HTML .= qq {<input type="checkbox" name="opt" value="x">Xvidモード\n};
		$HTML .= qq {<input type="submit" value="予約">\n</form>\n};
	}
	goto end;
}

if ( $mode eq 'reserve' ) {
	$HTML .= qq {<div style="float:left;">\n};
	&parse_program();
	@opt = $q->param( 'opt' );
	$opt = join '', @opt;
	if ( !&check_error ) {
		$dbh->do( 
			"INSERT INTO rectime ( type, chtxt, title, btime, etime, opt ) 
			VALUES ( 'res', '$chtxt', '$title', '$begin', '$end', '$opt' )" 
		);
	}
	$HTML .= "録画予約を実行しました。<br>\n5秒後に初期画面へ移動します。<br>\n";
	$HTML =~ s|%REFRESH%|<meta http-equiv="refresh" content="5; url=rectool.pl">|;
	goto end;
}

if ( $mode eq 'program' ) {
	&draw_form();
}

if ( !$mode ) {
	&draw_form();
	$HTML .= qq{Welcome to Rec10!<br>\n};
	$HTML .= qq{予約確認画面はこちら<a href="rectool.pl?mode=schedule">Mode=Schedule</a><br>\n};
	goto end;
}

$unix = UnixDate('now', '%Y%m%d%H%M%S');
$sql = 
	"SELECT channel, start, stop, title 
	FROM tv 
	INNER JOIN chdata ON tv.channel = chdata.ontv 
	WHERE stop >= $unix %CH% %DATE% %KEY% ORDER BY start";
if ( $channel ) {
	my $ch = "AND channel = '$channel'";
	$sql =~ s/%CH%/$ch/;
}
if ( $date_sel ) {
	my $date = sprintf( "AND stop >= '%08d000000' AND start <= '%08d000000'", $date_sel, $date_sel + 1 );
	$sql =~ s/%DATE%/$date/;
}
if ( $key ) {
	my $key = "AND TITLE LIKE '%$key%'";
	$sql =~ s/%DATE%/$key/;
}
$sql =~ s/%CH%//;
$sql =~ s/%DATE%//;
$sql =~ s/%KEY%//;

$ary_ref = $dbh->selectall_arrayref( $sql );
foreach my $prg ( @{ $ary_ref } ) {
	#$date1 = ParseDate( $prg->[1] );
	#$date2 = ParseDate( $prg->[2] );
	#$delta = DateCalc( $date1, $date2 );
	my $date1 = UnixDate($prg->[1], "%s");
	my $date2 = UnixDate($prg->[2], "%s");
	my $len   = ( $date2 - $date1 ) / 60;
	my @date  = $prg->[1] =~ /(.{4})(.{2})(.{2})(.{2})(.{2})/;
	if ( $prev[2] != $date[2] ) {
		$dt = DateTime->new( year => $date[0], month => $date[1], day => $date[2], 
			hour => $date[3], minute => $date[4], second => 0, locale => 'ja_JP' );
		my $dn = $dt ->day_name;
		utf8::encode( $dn );
		$HTML .= qq {--------$date[1]/$date[2]($dn)--------<br>\n};
	}
	my $display = $dbh->selectrow_array("SELECT display FROM ch WHERE channel = '$prg->[0]'");
	$display = url_encode( $display );
	$HTML .= qq {$date[1]/$date[2] $date[3]:$date[4] <a href="rectool.pl?mode=confirm&amp;ch=$display&amp;};
	$HTML .= qq {start=$prg->[1]&amp;stop=$prg->[2]">$prg->[3]</a><br>\n};
	@prev = @date;
}

end:
$HTML .= <<EOM;
</div>
</body>
</html>
EOM

$HTML =~ s/%REFRESH%//;

print $HTML;

sub draw_form {
	$channel = $dbh->selectrow_array("SELECT channel FROM ch WHERE display = '$display' ");

	# チャンネル指定
	$HTML .= qq {<form method="get" action="rectool.pl">\n};
	$HTML .= qq {<input type="hidden" name="mode" value="program">\n};
	$HTML .= qq {<select name="ch">\n<option value="" selected>無指定</option>\n};
	$ary_ref = $dbh->selectcol_arrayref("SELECT display FROM ch INNER JOIN chdata ON ch.channel = chdata.ontv");
	foreach my $ch ( @{$ary_ref} ) {
		if ( $ch eq $display ) {
			$HTML .= qq {<option value="$ch" selected>$ch</option>\n};
		}
		else {
			$HTML .= qq {<option value="$ch">$ch</option>\n};
		}
	}
	$HTML .= qq {</select>\n};

	# 日付指定
	$HTML .= qq {<select name="date">\n<option value="" selected>無指定</option>\n};
	$ary_ref = $dbh->selectcol_arrayref("SELECT DISTINCT SUBSTR(start, 0, 9) FROM tv");
	$date_sel = $q->param( 'date' );
	foreach my $date ( @{ $ary_ref } ) {
		my @date = $date =~ /(.{4})(.{2})(.{2})/;
		$date_prt = "$date[1]/$date[2]";

		if ( $date eq $date_sel ) {
			$HTML .= qq {<option value="$date" selected>$date_prt</option>\n};
		}
		else {
			$HTML .= qq {<option value="$date">$date_prt</option>\n};
		}
	}
	$HTML .= qq {</select>\n};

	# キーワード指定
	$HTML .= qq{<input name="key" type="text" value="$key" style="width:200px;">\n};

	# フォーム描画
	$last_modified = localtime((stat 'rectool.pl')[9]);
	$HTML .= qq {<input type="submit" value="更新">\n</form>\n};
	$HTML .= qq {<span style="font-size: 6pt;">Last-Modified: $last_modified</span>\n};
	#HTML .= qq {<span style="font-size: 6pt; text-align: right;">広告クリックお願いします･･･</span>\n<br>\n};
	$HTML .= qq {<div style="float:left;">\n};
}

sub parse_program {
	@start   = $start =~ /(.{4})(.{2})(.{2})(.{2})(.{2})/;
	@stop    = $stop  =~ /(.{4})(.{2})(.{2})(.{2})(.{2})/;
	$channel = $dbh->selectrow_array("SELECT channel FROM ch  WHERE display = '$display'");
	$title   = $dbh->selectrow_array("SELECT title   FROM tv  WHERE channel = '$channel' AND start = '$start' AND stop = '$stop' ");
	$chtxt   = $dbh->selectrow_array("SELECT chtxt   FROM chdata WHERE ontv = '$channel'");
	$bctype  = $dbh->selectrow_array("SELECT bctype  FROM chdata WHERE ontv = '$channel'");
	if ( $bctype =~ /.s/ ) {
		$bctype = '_s';
	}
	elsif ( $bctype =~ /te/ ) {
		$bctype = 'te%';
	}
	$title =~ s/\(/-/g;
	$title =~ s/\)//g;
	$begin = sprintf( '%04d-%02d-%02d %02d:%02d:%02d', @start, '00' );
	$end   = sprintf( '%04d-%02d-%02d %02d:%02d:%02d', @stop , '00' );
}

sub check_error {
	my $is_error = 1;

	if ( $dbh->selectrow_array( 
		"SELECT COUNT(*) FROM rectime 
		WHERE type = 'res' AND chtxt = '$chtxt' AND title = '$title' AND btime = '$begin' AND etime = '$end'" 
	) ) {
		$HTML .= "同一の番組が既に存在します。<br>\n";
	}
	elsif ( ( scalar $dbh->selectrow_array( 
		"SELECT COUNT(*) FROM rectime 
		INNER JOIN chdata ON rectime.chtxt = chdata.chtxt 
		WHERE chdata.bctype LIKE '$bctype' AND 
		( 
			( btime < '$begin' AND '$begin' < etime ) 
				OR 
			( btime < '$end'   AND '$end'   < etime ) 
		)" 
	) ) >= 2 ) {
		$HTML .= "時間が被る番組が既に2個存在します。<br>\n";
	}
	else {
		$is_error = 0;
	}
	return $is_error;
}

